$ErrorActionPreference = "Stop"

$exeName = "ef.exe"
$installDir = "$env:USERPROFILE\AppData\Local\Programs\ef"
$configFile = Join-Path $env:USERPROFILE ".ef.yaml"

Write-Host "Uninstalling $exeName from $installDir"

# Remove binary if it exists
if (Test-Path "$installDir\$exeName") {
    Remove-Item "$installDir\$exeName" -Force
    Write-Host "$exeName removed."
} else {
    Write-Host "$exeName not found in $installDir."
}

# Try to remove install directory if empty
if (Test-Path $installDir) {
    $files = Get-ChildItem $installDir
    if ($files.Count -eq 0) {
        Remove-Item $installDir -Force
        Write-Host "Removed empty directory $installDir."
    }
}

# Remove from PATH (User)
$oldPath = [Environment]::GetEnvironmentVariable("Path", "User")
if ($oldPath -like "*$installDir*") {
    $newPath = ($oldPath.Split(";") | Where-Object { $_ -ne $installDir }) -join ";"
    [Environment]::SetEnvironmentVariable("Path", $newPath, "User")
    Write-Host "Removed $installDir from PATH."
} else {
    Write-Host "$installDir was not in PATH."
}

# Remove config file ~/.ef.yaml
if (Test-Path $configFile) {
    Remove-Item $configFile -Force
    Write-Host "Removed config file $configFile."
} else {
    Write-Host "No config file found at $configFile."
}

Write-Host ""
Write-Host "Uninstallation complete."
Write-Host "Close and reopen your terminal to refresh PATH."
