$ErrorActionPreference = "Stop"

$exeName = "ef.exe"
$installDir = "$env:USERPROFILE\AppData\Local\Programs\ef"

Write-Host "Installing $exeName to $installDir"

# Create directory if it does not exist
if (-not (Test-Path $installDir)) {
    New-Item -ItemType Directory -Force -Path $installDir | Out-Null
}

# Copy binary
Copy-Item -Path ".\$exeName" -Destination $installDir -Force

# Add to PATH (for future sessions)
$oldPath = [Environment]::GetEnvironmentVariable("Path", "User")
if ($oldPath -notlike "*$installDir*") {
    $newPath = "$oldPath;$installDir"
    [Environment]::SetEnvironmentVariable("Path", $newPath, "User")
    Write-Host "Added $installDir to PATH."
} else {
    Write-Host "$installDir is already in PATH."
}

Write-Host ""
Write-Host "Installation complete."
Write-Host "Open a new terminal and type: ef"