# ef - EenvoudigFactureren CLI

The `ef` command-line tool allows you to interact with the [EenvoudigFactureren](https://eenvoudigfactureren.be) platform directly from your terminal. Generate invoices, manage clients, automate your workflow — all from the command line.

---

## 🚀 Features

- Easily manage your invoices, quotes, orders and other documents
- Access and update clients, products, projects, and account settings
- Integrate into scripts or CI pipelines
- Works on Linux, macOS, and Windows

---

## 🧰 Installation

Download the appropriate binary for your platform from the [downloads page](https://eenvoudigfactureren.be/downloads).

### Linux

```bash
curl -LO https://eenvoudigfactureren.be/downloads/ef_linux_amd64.zip
unzip ef_linux_amd64.zip
chmod +x ef_linux_amd64
sudo mv ef_linux_amd64 /usr/local/bin/ef
```

### macOS (Intel or Apple Silicon)

```bash
curl -LO https://eenvoudigfactureren.be/downloads/ef_darwin_amd64.zip   # or ef_darwin_arm64.zip
unzip ef_darwin_*.zip
chmod +x ef_darwin_*
sudo mv ef_darwin_* /usr/local/bin/ef
```

### Windows

Download and extract `ef_windows_amd64.zip`, then place `ef.exe` in your PATH.

---

## 🔁 Shell Completions

Optional shell completions are available to make typing commands easier.

### Bash

```bash
ef completion bash > /etc/bash_completion.d/ef
```

### Zsh

```bash
ef completion zsh > "${fpath[1]}/_ef"
```

### PowerShell

```powershell
ef completion powershell > $PROFILE\ef.ps1
```

### Fish

```bash
ef completion fish > ~/.config/fish/completions/ef.fish
```

---

## 💡 Usage Examples

Before using the CLI, you need to connect it to your EenvoudigFactureren account:

```bash
ef connect
```

This command will guide you through the authentication process.

```bash
# Create a new invoice
ef invoice create --client 123 --description "Services" --amount 250

# List all clients
ef clients ls

# Show help for a specific command
ef invoices rm --help
```

---

## ❓ Support

For questions or feedback, please contact us at [support@eenvoudigfactureren.be](mailto:support@eenvoudigfactureren.be).

---

## 📄 License

This tool is free to use but remains the intellectual property of EenvoudigFactureren.\
See [LICENSE](./LICENSE) for full terms.

